


#import <Cocoa/Cocoa.h>


@protocol MCDNDProcessor <NSObject>

- (BOOL)writeObjects:(id)objects toPasteboard:(NSPasteboard*)aPasteboard subsetIdentifier: (NSString*)anIdentifier subordinate:(id)subordinate;

- (NSDragOperation)validateDrop:(id <NSDraggingInfo>)info onTargetObject:(id)object subsetIdentifier:(NSString*)anIdentifer 
				destinationView:(id)aDestination viewOptions:(NSDictionary*)options;

- (BOOL)processDrop: (id <NSDraggingInfo>)info onTargetObject:(id)object subsetIdentifier:(NSString*)anIdentifier
	destinationView: (id)aDestination viewOptions:(NSDictionary*)options;

- (NSArray*)dropTypes;
- (NSArray*)dropTypesForDNDSetupIdentifier: (NSString*)anIdentifier;

- (void)registerDNDSetup: (NSDictionary*)aSetup forIdentifier: (NSString*)anIdentifier;
- (void)registerDropSelector: (NSString*)aSelector forType: (NSString*)aType;
- (void)registerDragSelector: (NSString*)aSelector forType: (NSString*)aType;
- (void)registerValidateSelector: (NSString*)aSelector forType: (NSString*)aType;
@end
